package com.amity.socialcloud.sdk.chat.channel


import com.amity.socialcloud.sdk.core.user.AmityMembershipType
import com.amity.socialcloud.sdk.log.AmityLog
import com.google.common.base.Objects

enum class AmityChannelMembershipFilter(
    val apiKey: String,
    internal val memberships: List<AmityMembershipType>,
    internal val isMuted: Boolean?
) {
    ALL("all", listOf(AmityMembershipType.MEMBER, AmityMembershipType.BANNED), null),
    MEMBER("member", listOf(AmityMembershipType.MEMBER), null),
    MUTED("muted", ALL.memberships, true),
    BANNED("banned", listOf(AmityMembershipType.BANNED), null);

    companion object {
        @Deprecated("use enumOf instead")
        @JvmStatic
        fun fromApiKey(apiKey: String?): AmityChannelMembershipFilter {
            for (filter in values()) {
                if (Objects.equal(apiKey, filter.apiKey)) {
                    return filter
                }
            }
            AmityLog.e(Exception(), "unknown api key : %s of channel membership filter", apiKey)
            return ALL
        }

        fun enumOf(apiKey: String): AmityChannelMembershipFilter {
            return values().find {
                it.apiKey == apiKey
            } ?: ALL
        }
    }

}