package com.amity.socialcloud.sdk.chat.channel

import androidx.paging.PagedList
import androidx.paging.PagingData
import com.amity.socialcloud.sdk.core.permission.AmityRoles
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.channel.GetChannelMembershipPagedListUseCase
import com.ekoapp.ekosdk.internal.usecase.channel.GetChannelMembershipPagingSourceUseCase
import io.reactivex.Flowable

class AmityChannelMembershipQuery internal constructor(
    private val channelId: String,
    private val filter: AmityChannelMembershipFilter,
    private val roles: AmityRoles,
    private val sortOption: AmityChannelMembershipSortOption
) {

    fun query(): Flowable<PagedList<AmityChannelMember>> {
        return GetChannelMembershipPagedListUseCase().execute(
            channelId = channelId,
            filter = filter,
            roles = roles,
            sortOption = sortOption
        ).toV2()
    }

    fun getPagingData(): Flowable<PagingData<AmityChannelMember>> {
        return GetChannelMembershipPagingSourceUseCase().execute(
            channelId = channelId,
            filter = filter,
            roles = roles,
            sortOption = sortOption
        ).toV2()
    }

    class Builder(private val channelId: String) {

        private var roles = AmityRoles()
        private var filter: AmityChannelMembershipFilter = AmityChannelMembershipFilter.ALL
        private var sortOption: AmityChannelMembershipSortOption =
            AmityChannelMembershipSortOption.LAST_CREATED

        fun filter(filter: AmityChannelMembershipFilter): Builder {
            return apply {
                this.filter = filter
            }
        }

        fun roles(roles: List<String>): Builder {
            return apply {
                this.roles = AmityRoles(roles)
            }
        }

        @Deprecated(
            message = "This method is deprecated. Use roles() instead",
            level = DeprecationLevel.WARNING
        )
        fun role(role: String): Builder {
            return roles(listOf(role))
        }

        fun sortBy(sortOption: AmityChannelMembershipSortOption): Builder {
            return apply { this.sortOption = sortOption }
        }

        fun build(): AmityChannelMembershipQuery {
            return AmityChannelMembershipQuery(
                channelId = channelId,
                filter = filter,
                roles = roles,
                sortOption = sortOption
            )
        }
    }

}