package com.amity.socialcloud.sdk.chat.channel

import androidx.paging.PagingData
import com.amity.socialcloud.sdk.core.permission.AmityRoles
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.channel.SearchChannelMembershipPagingSourceUseCase
import io.reactivex.Flowable

class AmityChannelMemberSearch internal constructor(
    private val channelId: String,
    private val roles: AmityRoles,
    private val memberships: List<AmityChannelMembership>,
    private val keyword: String
) {

    fun getPagingData(): Flowable<PagingData<AmityChannelMember>> {
        return SearchChannelMembershipPagingSourceUseCase().execute(
            channelId,
            memberships,
            roles,
            keyword
        ).toV2()
    }

    class Builder private constructor() {
        private lateinit var channelId: String
        private lateinit var keyword: String
        private var roles = AmityRoles()
        // current BE default value
        private var memberships = listOf(AmityChannelMembership.MEMBER)


        internal constructor(channelId: String, keyword: String) : this() {
            this.channelId = channelId
            this.keyword = keyword
        }

        fun membershipFilter(channelMembership: List<AmityChannelMembership>): Builder {
            return apply {
                if(channelMembership.isNotEmpty()) {
                    this.memberships = channelMembership
                }
            }
        }

        fun roles(roles: List<String>): Builder {
            return apply {
                this.roles = AmityRoles(roles)
            }
        }

        fun build(): AmityChannelMemberSearch {
            return AmityChannelMemberSearch(channelId, roles, memberships, keyword)
        }
    }

}