package com.ekoapp.ekosdk.channel.message.query

import com.amity.socialcloud.sdk.chat.message.AmityMessage
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.message.GetLatestMessageUseCase
import io.reactivex.Flowable

class AmityChannelLatestMessageQuery(private val channelId: String, private val isDeleted: Boolean?) {

    fun query(): Flowable<AmityMessage> {
        return GetLatestMessageUseCase().execute(channelId, isDeleted).toV2()
    }

    class Builder internal constructor(private val channelId: String) {

        private var isDeleted: Boolean? = null

        fun isDeleted(isDeleted: Boolean): Builder {
            this.isDeleted = isDeleted
            return this
        }

        fun build(): AmityChannelLatestMessageQuery {
            return AmityChannelLatestMessageQuery(channelId, isDeleted)
        }
    }
}