package com.amity.socialcloud.sdk.chat.channel

import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.channel.*
import io.reactivex.Completable
import org.joda.time.Duration


class AmityChannelModeration(private val channelId: String) {

    fun addRole(role: String, userIds: List<String>): Completable {
        return AddRoleUseCase().execute(channelId, role, userIds).toV2()
    }

    fun removeRole(role: String, userIds: List<String>): Completable {
        return RemoveRoleUseCase().execute(channelId, role, userIds).toV2()
    }

    fun muteMembers(timeout: Duration, userIds: List<String>): Completable {
        return MuteUsersChannelUseCase().execute(channelId, timeout, userIds).toV2()
    }

    fun unmuteMembers(userIds: List<String>): Completable {
        return UnMuteUsersChannelUseCase().execute(channelId, userIds).toV2()
    }

    fun muteChannel(timeout: Duration): Completable {
        return MuteChannelUseCase().execute(channelId, timeout).toV2()
    }

    fun unmuteChannel(): Completable {
        return UnMuteChannelUseCase().execute(channelId).toV2()
    }

    fun banMembers(userIds: List<String>): Completable {
        return BanUsersChannelUseCase().execute(channelId, userIds).toV2()
    }

    fun unbanMembers(userIds: List<String>): Completable {
        return UnBanUsersChannelUseCase().execute(channelId, userIds).toV2()
    }

}