package com.amity.socialcloud.sdk.chat.channel

import com.amity.socialcloud.sdk.social.channel.AmityChannelNotificationSettings
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.channel.GetChannelNotificationUseCase
import com.ekoapp.ekosdk.internal.usecase.channel.SetAllowedNotificationUseCase
import io.reactivex.Completable
import io.reactivex.Single


class AmityChannelNotification(private val channelId: String) {


    fun enable(): Completable {
        return SetAllowedNotificationUseCase().execute(channelId, true).toV2()
    }

    fun disable(): Completable {
        return SetAllowedNotificationUseCase().execute(channelId, false).toV2()
    }

    fun getSettings(): Single<AmityChannelNotificationSettings> {
        return GetChannelNotificationUseCase().execute(channelId).toV2()
    }
}