package com.amity.socialcloud.sdk.chat.channel

import com.amity.socialcloud.sdk.core.user.AmityMembershipType
import com.amity.socialcloud.sdk.log.AmityLog
import com.google.common.base.Objects

enum class AmityChannelFilter(val apiKey: String, val memberships: List<String>) {
    ALL("all", emptyList<String>()), MEMBER("member", listOf(AmityMembershipType.MEMBER.apiKey)), NOT_MEMBER("notMember", listOf(AmityMembershipType.NONE.apiKey, AmityMembershipType.BANNED.apiKey));

    companion object {
        @JvmStatic
        fun fromApiKey(apiKey: String?): AmityChannelFilter {
            for (filter in values()) {
                if (Objects.equal(apiKey, filter.apiKey)) {
                    return filter
                }
            }
            AmityLog.e(Exception(), "unknown api key : %s of channel filter", apiKey)
            return MEMBER
        }

        fun enumOf(apiKey: String) : AmityChannelFilter {
            return values().find {
                it.apiKey == apiKey
            } ?: ALL
        }
    }

}