package com.amity.socialcloud.sdk.chat.channel

import androidx.paging.PagedList
import androidx.paging.PagingData
import com.amity.socialcloud.sdk.core.AmityTags
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.channel.GetChannelPagedListUseCase
import com.ekoapp.ekosdk.internal.usecase.channel.GetChannelPagingDataUseCase
import io.reactivex.Flowable

abstract class AmityChannelQuery internal constructor(private val isDeleted: Boolean?,
                                                      private val types: Set<AmityChannel.Type>,
                                                      private val filter: AmityChannelFilter,
                                                      private val includingTags: AmityTags,
                                                      private val excludingTags: AmityTags) {

    fun query(): Flowable<PagedList<AmityChannel>> {
        return GetChannelPagedListUseCase().execute(isDeleted, types, filter, includingTags, excludingTags, AmityChannelSortOption.LAST_ACTIVITY).toV2()
    }

    fun getPagingData(): Flowable<PagingData<AmityChannel>> {
        return GetChannelPagingDataUseCase().execute(isDeleted, types, filter, includingTags, excludingTags).toV2()
    }

}