package com.amity.socialcloud.sdk.chat.channel

import com.amity.socialcloud.sdk.core.AmityTags
import com.google.common.collect.FluentIterable
import com.google.common.collect.Sets

class AmityChannelQueryByTypes private constructor(isDeleted: Boolean?,
                                                   types: Set<AmityChannel.Type>,
                                                   filter: AmityChannelFilter,
                                                   includingTags: AmityTags,
                                                   excludingTags: AmityTags) : AmityChannelQuery(isDeleted, types, filter, includingTags, excludingTags) {
    class Builder {
        private var isDeleted: Boolean? = null
        private var types: Set<AmityChannel.Type> = Sets.newHashSet()
        private var filter: AmityChannelFilter = AmityChannelFilter.ALL
        private var includingTags = AmityTags()
        private var excludingTags = AmityTags()

        fun includeDeleted(includeDeleted: Boolean): Builder {
            if (!includeDeleted) {
                isDeleted = false
            }
            return this
        }

        fun types(types: List<AmityChannel.Type>): Builder {
            this.types = FluentIterable.from(types).toSet()
            return this
        }

        fun filter(filter: AmityChannelFilter): Builder {
            this.filter = filter
            return this
        }

        fun includingTags(includingTags: AmityTags): Builder {
            this.includingTags = includingTags
            return this
        }

        fun excludingTags(excludingTags: AmityTags): Builder {
            this.excludingTags = excludingTags
            return this
        }

        fun build(): AmityChannelQueryByTypes {
            return AmityChannelQueryByTypes(isDeleted, types, filter, includingTags, excludingTags)
        }
    }

}