package com.amity.socialcloud.sdk.chat.channel

import com.amity.socialcloud.sdk.core.AmityTags
import com.google.common.collect.Sets

class AmityCommunityChannelQuery private constructor(isDeleted: Boolean?,
                                                     filter: AmityChannelFilter,
                                                     includingTags: AmityTags,
                                                     excludingTags: AmityTags)
    : AmityChannelQuery(isDeleted,
                Sets.newHashSet(AmityChannel.Type.COMMUNITY),
                filter,
                includingTags,
                excludingTags) {

    class Builder {
        private var isDeleted: Boolean? = null
        private var filter = AmityChannelFilter.ALL
        private var includingTags = AmityTags()
        private var excludingTags = AmityTags()

        fun includeDeleted(includeDeleted: Boolean): Builder {
            if (!includeDeleted) {
                isDeleted = false
            }
            return this
        }

        fun filter(filter: AmityChannelFilter): Builder {
            return apply { this.filter = filter }
        }

        fun includingTags(includingTags: AmityTags): Builder {
            return apply { this.includingTags = includingTags }
        }

        fun excludingTags(excludingTags: AmityTags): Builder {
            return apply { this.excludingTags = excludingTags }
        }

        fun build(): AmityCommunityChannelQuery {
            return AmityCommunityChannelQuery(isDeleted, filter, includingTags, excludingTags)
        }
    }

}