package com.amity.socialcloud.sdk.chat.channel

import com.amity.socialcloud.sdk.core.AmityTags
import com.google.common.collect.Sets

class AmityLiveChannelQuery private constructor(isDeleted: Boolean?,
                                                includingTags: AmityTags,
                                                excludingTags: AmityTags)
    : AmityChannelQuery(isDeleted,
                Sets.newHashSet(AmityChannel.Type.LIVE),
                AmityChannelFilter.MEMBER,
                includingTags,
                excludingTags) {

    class Builder {
        private var isDeleted: Boolean? = null
        private var includingTags = AmityTags()
        private var excludingTags = AmityTags()
        private var sortBy: AmityChannelSortOption = AmityChannelSortOption.LAST_ACTIVITY

        fun includeDeleted(includeDeleted: Boolean): Builder {
            if (!includeDeleted) {
                isDeleted = false
            }
            return this
        }

        fun includingTags(includingTags: AmityTags): Builder {
            return apply { this.includingTags = includingTags }
        }

        fun excludingTags(excludingTags: AmityTags): Builder {
            return apply { this.excludingTags = excludingTags }
        }

        fun build(): AmityLiveChannelQuery {
            return AmityLiveChannelQuery( isDeleted, includingTags, excludingTags)
        }
    }
}