package com.amity.socialcloud.sdk.chat.channel

import com.amity.socialcloud.sdk.core.AmityTags
import com.google.common.collect.Sets

class AmityPrivateChannelQuery private constructor(isDeleted: Boolean?,
                                                   includingTags: AmityTags,
                                                   excludingTags: AmityTags)
    : AmityChannelQuery(isDeleted,
        Sets.newHashSet(AmityChannel.Type.PRIVATE),
        AmityChannelFilter.MEMBER,
        includingTags,
        excludingTags) {

    class Builder {
        private var isDeleted: Boolean? = null
        private var includingTags = AmityTags()
        private var excludingTags = AmityTags()
        private var sortBy = AmityChannelSortOption.LAST_ACTIVITY

        fun includeDeleted(includeDeleted: Boolean): Builder {
            if (!includeDeleted) {
                isDeleted = false
            }
            return this
        }

        fun includingTags(includingTags: AmityTags): Builder {
            this.includingTags = includingTags
            return this
        }

        fun excludingTags(excludingTags: AmityTags): Builder {
            this.excludingTags = excludingTags
            return this
        }

        fun build(): AmityPrivateChannelQuery {
            return AmityPrivateChannelQuery(isDeleted, includingTags, excludingTags)
        }
    }

}