package com.amity.socialcloud.sdk.chat.channel

import com.amity.socialcloud.sdk.core.AmityTags
import com.google.common.collect.Sets

class AmityStandardChannelQuery private constructor(isDeleted: Boolean?,
                                                    filter: AmityChannelFilter,
                                                    includingTags: AmityTags,
                                                    excludingTags: AmityTags)
    : AmityChannelQuery(
        isDeleted,
        Sets.newHashSet(AmityChannel.Type.STANDARD),
        filter,
        includingTags,
        excludingTags) {

    class Builder {
        private var isDeleted: Boolean? = null
        private var filter = AmityChannelFilter.ALL
        private var includingTags = AmityTags()
        private var excludingTags = AmityTags()
        private var sortBy = AmityChannelSortOption.LAST_ACTIVITY

        fun includeDeleted(includeDeleted: Boolean): Builder {
            if (!includeDeleted) {
                isDeleted = false
            }
            return this
        }

        fun filter(filter: AmityChannelFilter): Builder {
            this.filter = filter
            return this
        }

        fun includingTags(includingTags: AmityTags): Builder {
            this.includingTags = includingTags
            return this
        }

        fun excludingTags(excludingTags: AmityTags): Builder {
            this.excludingTags = excludingTags
            return this
        }

        fun build(): AmityStandardChannelQuery {
            return AmityStandardChannelQuery(isDeleted, filter, includingTags, excludingTags)
        }
    }

}