package com.ekoapp.ekosdk.channel.update

import com.amity.socialcloud.sdk.chat.channel.AmityChannel
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.repository.channel.ChannelUpdateOption
import com.ekoapp.ekosdk.internal.usecase.channel.UpdateChannelUseCase
import io.reactivex.Single

class AmityChannelUpdate internal constructor(private var channelId: String, private var option: ChannelUpdateOption) {

    fun update(): Single<AmityChannel> {
        return updateChannel()
    }

    private fun updateChannel(): Single<AmityChannel> {
        return UpdateChannelUseCase().execute(channelId, option).toV2()
    }

}