package com.amity.socialcloud.sdk.chat.channel


import com.amity.socialcloud.sdk.core.AmityTags
import com.amity.socialcloud.sdk.core.file.AmityImage
import com.ekoapp.ekosdk.channel.update.AmityChannelUpdate
import com.ekoapp.ekosdk.internal.repository.channel.ChannelUpdateOption
import com.google.gson.JsonObject

class AmityChannelWithChannelIdUpdate {

    class Builder(private val channelId: String) {
        private var displayName: String? = null
        private var avatarFileId: String? = null
        private var metadata: JsonObject? = null
        private var tags: AmityTags? = null

        fun displayName(displayName: String): Builder {
            return apply { this.displayName = displayName }
        }

        fun avatar(avatar: AmityImage): Builder {
            return apply { this.avatarFileId = avatar.getFileId() }
        }

        fun metadata(metadata: JsonObject): Builder {
            return apply { this.metadata = metadata }
        }

        fun tags(tags: AmityTags): Builder {
            return apply { this.tags = tags }
        }

        fun build(): AmityChannelUpdate {
            val option = ChannelUpdateOption(
                    displayName = displayName,
                    metadata = metadata,
                    avatarFileId = avatarFileId,
                    tags = tags)

            return AmityChannelUpdate(channelId = channelId, option = option)
        }
    }
}