package com.amity.socialcloud.sdk.social.comment

import com.ekoapp.ekosdk.comment.CommentType

class AmityCommentCreateTargeter internal constructor(private val commentId: String? = null) {

    class Builder internal constructor(private val referenceType: String,
                                       private val referenceId: String,
                                       private val commentId: String? = null) {

        private var parentId: String? = null

        fun parentId(parentId: String?): Builder {
            return apply { this.parentId = parentId }
        }

        fun with(): AmityCommentCreateTypeSelector {
            return AmityCommentCreateTypeSelector(referenceType, referenceId, parentId, commentId)
        }
    }

    fun post(postId: String): Builder {
        return Builder(CommentType.POST.value, postId, commentId)
    }

    fun content(contentId: String): Builder {
        return Builder(CommentType.CONTENT.value, contentId, commentId)
    }

}