package com.ekoapp.ekosdk.comment.create

import com.amity.socialcloud.sdk.core.mention.AmityMentioneeTarget
import com.amity.socialcloud.sdk.social.comment.AmityComment
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.comment.CreateCommentUseCase
import com.google.gson.JsonObject
import io.reactivex.Single

abstract class AmityCommentCreator internal constructor(
    val referenceType: String,
    val referenceId: String,
    val parentId: String?,
    val commentId: String?,
    val metadata: JsonObject?,
    internal val mentionees: List<AmityMentioneeTarget>?
) {

    abstract fun getData(): JsonObject

    fun send(): Single<AmityComment> {
        return CreateCommentUseCase().execute(
            referenceType,
            referenceId,
            parentId,
            commentId,
            getData(),
            metadata,
            mentionees
        ).toV2()
    }

}
