package com.amity.socialcloud.sdk.social.comment


import com.amity.socialcloud.sdk.core.mention.AmityMentionType
import com.amity.socialcloud.sdk.core.mention.AmityMentioneeTarget
import com.ekoapp.ekosdk.comment.create.AmityCommentCreator
import com.google.gson.JsonObject


class AmityTextCommentCreator private constructor(
    referenceType: String,
    referenceId: String,
    parentId: String?,
    commentId: String?,
    private val text: String,
    metadata: JsonObject?,
    mentionees: List<AmityMentioneeTarget>?
) : AmityCommentCreator(referenceType, referenceId, parentId, commentId, metadata, mentionees) {

    override fun getData(): JsonObject {
        val data = JsonObject()
        data.addProperty("text", text)
        return data
    }

    class Builder {
        private var referenceType: String = ""
        private var referenceId: String = ""
        private var parentId: String? = null
        private var text: String = ""
        private var commentId: String? = null
        private var metadata: JsonObject? = null
        private var mentionees: List<AmityMentioneeTarget>? = null

        internal fun referenceType(referenceType: String): Builder {
            return apply { this.referenceType = referenceType }
        }

        internal fun referenceId(referenceId: String): Builder {
            return apply { this.referenceId = referenceId }
        }

        internal fun parentId(parentId: String?): Builder {
            return apply { this.parentId = parentId }
        }

        internal fun text(text: String): Builder {
            return apply { this.text = text }
        }

        internal fun commentId(commentId: String?): Builder {
            return apply {
                this.commentId = commentId
            }
        }

        fun metadata(metadata: JsonObject): Builder {
            this.metadata = metadata
            return this
        }

        fun mentionUsers(userIds: List<String>): Builder {
            this.mentionees = listOf(AmityMentioneeTarget(AmityMentionType.USER.apiKey, userIds))
            return this
        }

        fun build(): AmityTextCommentCreator {
            return AmityTextCommentCreator(
                referenceType, referenceId, parentId,
                commentId, text, metadata, mentionees
            )
        }
    }

}
