package com.amity.socialcloud.sdk.social.comment

import com.amity.socialcloud.sdk.core.mention.AmityMentionType
import com.amity.socialcloud.sdk.core.mention.AmityMentioneeTarget
import com.google.gson.JsonObject

class AmityTextCommentEditor internal constructor(
    commentId: String,
    private val text: String?,
    metadata: JsonObject?,
    mentionees: List<AmityMentioneeTarget>?
) : CommentEditor(commentId, metadata, mentionees) {


    override fun getData(): JsonObject {
        val data = JsonObject()
        text?.let {
            data.addProperty("text", text)
        }
        return data
    }

    class Builder(private val commentId: String) {

        private var text: String? = null
        private var metadata: JsonObject? = null
        private var mentionees: List<AmityMentioneeTarget>? = null

        fun text(text: String): Builder {
            return apply {
                this.text = text
            }
        }

        fun metadata(metadata: JsonObject): Builder {
            this.metadata = metadata
            return this
        }

        fun mentionUsers(userIds: List<String>): Builder {
            this.mentionees = listOf(AmityMentioneeTarget(AmityMentionType.USER.apiKey, userIds))
            return this
        }

        fun build(): AmityTextCommentEditor {
            return AmityTextCommentEditor(commentId, text, metadata, mentionees)
        }
    }

}