package com.amity.socialcloud.sdk.social.comment

import com.amity.socialcloud.sdk.core.mention.AmityMentioneeTarget
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.comment.EditCommentUseCase
import com.google.gson.JsonObject
import io.reactivex.Single

abstract class CommentEditor internal constructor(
    private val commentId: String,
    private val metadata: JsonObject?,
    private val mentionees: List<AmityMentioneeTarget>?
) {

    internal abstract fun getData(): JsonObject

    fun apply(): Single<AmityComment> {
        return EditCommentUseCase().execute(commentId, getData(), metadata, mentionees).toV2()
    }

}