package  com.amity.socialcloud.sdk.social.comment

import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.report.AmityFlagType
import com.ekoapp.ekosdk.internal.report.AmityFlagger
import com.ekoapp.ekosdk.internal.usecase.comment.FlagCommentUseCase
import com.ekoapp.ekosdk.internal.usecase.comment.UnFlagCommentUseCase
import io.reactivex.Completable

class AmityCommentFlagger internal constructor(private val commentId: String) : AmityFlagger() {

    private fun flag(vararg flagTypes: AmityFlagType): Completable {
        return FlagCommentUseCase().execute(commentId, *flagTypes).toV2()
    }

    private fun unflag(vararg flagTypes: AmityFlagType): Completable {
        return UnFlagCommentUseCase().execute(commentId, *flagTypes).toV2()
    }

    fun flag(): Completable {
        return flag(AmityFlagType.SPAM)
    }

    fun unflag(): Completable {
        return unflag(AmityFlagType.SPAM)
    }

}