package com.amity.socialcloud.sdk.social.comment

import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.comment.LatestCommentQueryUseCase
import io.reactivex.Single


class AmityLatestCommentQuery internal constructor(
    private val referenceId: String,
    private val referenceType: String,
    private val isFilterByParentId: Boolean
) {

    fun query(): Single<AmityComment> {
        return LatestCommentQueryUseCase().execute(referenceId, referenceType, isFilterByParentId)
            .toV2()
    }

    class Builder {
        private lateinit var referenceId: String
        private lateinit var referenceType: String
        private var isFilterByParentId: Boolean = false

        fun includeReplies(includeReplies: Boolean): Builder {
            this.isFilterByParentId = !includeReplies
            return this
        }

        internal fun referenceType(referenceType: String): Builder {
            return apply { this.referenceType = referenceType }
        }

        internal fun referenceId(referenceId: String): Builder {
            return apply { this.referenceId = referenceId }
        }

        fun build(): AmityLatestCommentQuery {
            return AmityLatestCommentQuery(
                referenceId = referenceId,
                referenceType = referenceType,
                isFilterByParentId = isFilterByParentId
            )
        }
    }

}