package com.amity.socialcloud.sdk.social.comment

import com.ekoapp.ekosdk.comment.CommentType

class AmityLatestCommentQueryTypeSelector internal constructor() {

    fun post(postId: String): AmityLatestCommentQuery.Builder {
        return AmityLatestCommentQuery.Builder()
                .referenceType(CommentType.POST.value)
                .referenceId(postId)
    }

    fun content(contentId: String): AmityLatestCommentQuery.Builder {
        return AmityLatestCommentQuery.Builder()
                .referenceType(CommentType.CONTENT.value)
                .referenceId(contentId)
    }

}