package com.amity.socialcloud.sdk.social.comment

import com.amity.socialcloud.sdk.log.AmityLog
import com.amity.socialcloud.sdk.social.community.AmityQuerySortingOrder
import com.google.common.base.Objects

enum class AmityCommentSortOption(val apiKey: String,
                                  val sortingColumn: String,
                                  val sortingOrder: String) {
    FIRST_CREATED("firstCreated", "comment.createdAt", AmityQuerySortingOrder.ASC.sqlOrder), LAST_CREATED("lastCreated", "comment.createdAt", AmityQuerySortingOrder.DESC.sqlOrder);

    companion object {
        fun fromApiKey(apiKey: String?): AmityCommentSortOption {
            for (filter in values()) {
                if (Objects.equal(apiKey, filter.apiKey)) {
                    return filter
                }
            }
            AmityLog.e(Exception(), "unknown api key : %s of user sort option", apiKey)
            return LAST_CREATED
        }
    }
}