package com.amity.socialcloud.sdk.social.comment

import androidx.paging.PagedList
import androidx.paging.PagingData
import com.ekoapp.ekosdk.internal.usecase.comment.CommentListQueryUseCase
import com.ekoapp.ekosdk.internal.usecase.comment.CommentPagingDataUseCase
import io.reactivex.Flowable

class AmityCommentQuery internal constructor(private val referenceId: String,
                                             private val referenceType: String,
                                             private val isFilterByParentId: Boolean,
                                             private val parentId: String?,
                                             private val isDeleted: Boolean?,
                                             private val sortOption: AmityCommentSortOption) {

    @Deprecated("use pagingData() instead")
    fun query(): Flowable<PagedList<AmityComment>> {
        return CommentListQueryUseCase().execute(referenceId, referenceType,
                isFilterByParentId, parentId, isDeleted, sortOption)
    }

    fun loader(): AmityCommentLoader {
        return AmityCommentLoader(referenceId, referenceType, isFilterByParentId, parentId, isDeleted, sortOption)
    }

    fun getPagingData(): Flowable<PagingData<AmityComment>> {
        return CommentPagingDataUseCase().execute(
            referenceId, referenceType,
            isFilterByParentId, parentId, isDeleted, sortOption
        )
    }

    class Builder {
        private lateinit var referenceId: String
        private lateinit var referenceType: String
        private var parentId: String? = null
        private var isFilterByParentId: Boolean = false
        private var isDeleted: Boolean? = null
        private var sortOption: AmityCommentSortOption = AmityCommentSortOption.LAST_CREATED

        fun includeDeleted(includeDeleted: Boolean): Builder {
            if (!includeDeleted) {
                this.isDeleted = false
            }
            return this
        }

        fun parentId(parentId: String?): Builder {
            this.parentId = parentId
            this.isFilterByParentId = true
            return this
        }

        fun sortBy(sortOption: AmityCommentSortOption): Builder {
            return apply { this.sortOption = sortOption }
        }

        internal fun referenceType(referenceType: String): Builder {
            return apply { this.referenceType = referenceType }
        }

        internal fun referenceId(referenceId: String): Builder {
            return apply { this.referenceId = referenceId }
        }

        fun build(): AmityCommentQuery {
            return AmityCommentQuery(
                    referenceId = referenceId,
                    referenceType = referenceType,
                    isFilterByParentId = isFilterByParentId,
                    parentId = parentId,
                    isDeleted = isDeleted,
                    sortOption = sortOption)
        }
    }
}