package com.amity.socialcloud.sdk.social.comment

import com.ekoapp.ekosdk.comment.CommentType

class AmityCommentQueryTypeSelector internal constructor() {

    fun post(postId: String): AmityCommentQuery.Builder {
        return AmityCommentQuery.Builder()
                .referenceType(CommentType.POST.value)
                .referenceId(postId)
    }

    fun content(contentId: String): AmityCommentQuery.Builder {
        return AmityCommentQuery.Builder()
                .referenceType(CommentType.CONTENT.value)
                .referenceId(contentId)
    }

}