package com.amity.socialcloud.sdk.social.community

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.amity.socialcloud.sdk.core.file.AmityImage
import com.google.gson.JsonObject
import kotlinx.android.parcel.Parcelize
import kotlinx.android.parcel.TypeParceler
import org.joda.time.DateTime

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
data class AmityCommunityCategory internal constructor(
    private val categoryId: String,
    private val name: String,
    internal var avatarFileId: String?,
    internal var avatar: AmityImage?,
    private val metadata: JsonObject?,
    private val isDeleted: Boolean,
    private val createdAt: DateTime?,
    private val updatedAt: DateTime?
) : AmityCommunityCategoryContract, Parcelable {

    override fun getCategoryId(): String {
        return categoryId
    }

    override fun getName(): String {
        return name
    }

    override fun getAvatar(): AmityImage? {
        return avatar
    }

    override fun getMetadata(): JsonObject? {
        return metadata
    }

    override fun isDeleted(): Boolean {
        return isDeleted
    }

    override fun getCreatedAt(): DateTime? {
        return createdAt
    }

    override fun getUpdatedAt(): DateTime? {
        return updatedAt
    }
}