package com.ekoapp.ekosdk.community.category

import androidx.room.Entity
import androidx.room.Ignore
import androidx.room.Index
import androidx.room.PrimaryKey
import com.amity.socialcloud.sdk.core.file.AmityImage
import com.ekoapp.ekosdk.EkoObject
import com.ekoapp.ekosdk.internal.EkoFileEntity
import com.ekoapp.ekosdk.internal.mapper.AmityFilePropertiesMapper
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import com.google.gson.JsonObject
import org.amity.types.ObjectId


@Entity(tableName = "community_category", indices = [Index("categoryId")])
open class CommunityCategoryEntity : EkoObject() {

    @PrimaryKey
    var categoryId: String = ObjectId.get().toHexString()
    var name: String = ""
    var avatarFileId: String? = null
    var metadata: JsonObject? = null
    var isDeleted: Boolean = false

    override fun getId(): String {
        return categoryId
    }

    override fun equals(obj: Any?): Boolean {
        if (obj == null) return false
        if (obj === this) return true
        if (obj.javaClass != javaClass) return false
        val other = obj as CommunityCategoryEntity
        return (Objects.equal(categoryId, other.categoryId)
                && Objects.equal(name, other.name)
                && Objects.equal(avatarFileId, other.avatarFileId)
                && Objects.equal(metadata, other.metadata)
                && Objects.equal(isDeleted, other.isDeleted))
    }

    override fun hashCode(): Int {
        return Objects.hashCode(categoryId, name, avatarFileId, metadata, isDeleted)
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper): String {
        toStringHelper.add("categoryId", categoryId)
            .add("name", name)
            .add("avatarFileId", avatarFileId)
            .add("metadata", metadata)
            .add("isDeleted", isDeleted)
        return super.internalToString(toStringHelper)
    }
}