package com.amity.socialcloud.sdk.social.community

import androidx.paging.PagedList
import androidx.paging.PagingData
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.community.QueryCommunityCategoryListPagingDataUseCase
import com.ekoapp.ekosdk.internal.usecase.community.QueryCommunityCategoryListUseCase
import io.reactivex.Flowable

class AmityCommunityCategoryQuery internal constructor(private val sortOption: AmityCommunityCategorySortOption,
                                                       private val includeDeleted: Boolean?) {
    
    @Deprecated("Use getPagingData() instead")
    fun query(): Flowable<PagedList<AmityCommunityCategory>> {
        return QueryCommunityCategoryListUseCase().execute(sortOption, includeDeleted).toV2()
    }
    
    fun getPagingData(): Flowable<PagingData<AmityCommunityCategory>> {
        return QueryCommunityCategoryListPagingDataUseCase().execute(sortOption, includeDeleted).toV2()
    }

    class Builder {
        private var isDeleted: Boolean? = null
        private var sortBy: AmityCommunityCategorySortOption = AmityCommunityCategorySortOption.NAME

        fun includeDeleted(includeDeleted: Boolean): Builder {
            if (!includeDeleted) {
                this.isDeleted = false
            }
            return this
        }

        fun sortBy(sortOption: AmityCommunityCategorySortOption): Builder {
            return apply {
                this.sortBy = sortOption
            }
        }

        fun build(): AmityCommunityCategoryQuery {
            return AmityCommunityCategoryQuery(sortBy, isDeleted)
        }
    }
}
