package com.amity.socialcloud.sdk.social.community

import com.amity.socialcloud.sdk.log.AmityLog
import com.google.common.base.Objects

enum class AmityCommunityCategorySortOption(val apiKey: String) {
    NAME("name"), FIRST_CREATED("firstCreated"), LAST_CREATED("lastCreated");

    companion object {
        fun fromApiKey(apiKey: String?): AmityCommunityCategorySortOption {
            for (filter in values()) {
                if (Objects.equal(apiKey, filter.apiKey)) {
                    return filter
                }
            }
            AmityLog.e(Exception(), "unknown api key : %s of user sort option", apiKey)
            return NAME
        }
    }
}