package com.amity.socialcloud.sdk.social.community

import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.community.CreateCommunityUseCase
import com.google.gson.JsonObject
import io.reactivex.Single

class AmityCommunityCreator {
    private var displayName: String
    private var description: String? = null
    private var isPublic: Boolean? = false
    private var categoryIds: List<String>? = null
    private var metadata: JsonObject? = null
    private var userIds: List<String>? = null
    private var avatarFileId: String? = null
    private var needApprovalOnPostCreation:Boolean? = null
    private var onlyAdminCanPost: Boolean? = null

    internal constructor(displayName: String,
                         description: String?,
                         isPublic: Boolean?,
                         categoryIds: List<String>?,
                         metadata: JsonObject?,
                         userIds: List<String>?,
                         avatarFileId: String?,
                         needApprovalOnPostCreation:Boolean?,
                         onlyAdminCanPost: Boolean?) {

        this.displayName = displayName
        this.description = description
        this.isPublic = isPublic
        this.categoryIds = categoryIds
        this.metadata = metadata
        this.userIds = userIds
        this.avatarFileId = avatarFileId
        if (this.description?.isEmpty() == true) {
            this.description = null
        }
        this.needApprovalOnPostCreation = needApprovalOnPostCreation
        this.onlyAdminCanPost = onlyAdminCanPost
    }


    fun create(): Single<AmityCommunity> {
        return createCommunity()
    }

    private fun createCommunity(): Single<AmityCommunity> {
        return CreateCommunityUseCase()
                .execute(
                    displayName,
                    description,
                    categoryIds,
                    isPublic,
                    metadata,
                    userIds,
                    avatarFileId,
                    needApprovalOnPostCreation,
                    onlyAdminCanPost).toV2()
    }

}