package com.amity.socialcloud.sdk.social.community

import com.amity.socialcloud.sdk.core.file.AmityImage
import com.ekoapp.ekosdk.community.update.AmityCommunityPostSettings
import com.google.gson.JsonObject

class AmityCommunityWithDisplayNameCreateByAdmin {
    class Builder(private val displayName: String) {
        private var description: String? = null
        private var isPublic: Boolean? = false
        private var categoryIds: List<String>? = null
        private var metadata: JsonObject? = null
        private var userIds: List<String>? = null
        private var avatarFileId: String? = null
        private var needApprovalOnPostCreation: Boolean? = null
        private var onlyAdminCanPost: Boolean? = null

        fun description(description: String): Builder {
            return apply { this.description = description }
        }

        fun isPublic(isPublic: Boolean): Builder {
            return apply { this.isPublic = isPublic }
        }

        fun categoryIds(categoryIds: List<String>): Builder {
            return apply { this.categoryIds = categoryIds }
        }

        fun metadata(metadata: JsonObject): Builder {
            return apply { this.metadata = metadata }
        }

        fun userIds(userIds: List<String>): Builder {
            return apply { this.userIds = userIds }
        }

        fun avatar(avatar: AmityImage): Builder {
            return apply { this.avatarFileId = avatar.getFileId() }
        }
    
        @Deprecated("Use postSettings() instead")
        fun isPostReviewEnabled(isPostReviewEnabled:Boolean): Builder {
            return apply { needApprovalOnPostCreation = isPostReviewEnabled }
        }
    
        fun postSettings(postSettings: AmityCommunityPostSettings): Builder {
            return apply {
                this.needApprovalOnPostCreation = postSettings.isPostReviewEnabled
                this.onlyAdminCanPost = postSettings.onlyAdminCanPost
            }
        }

        fun build(): AmityCommunityCreator {
            return AmityCommunityCreator(
                    displayName = displayName,
                    description = description,
                    isPublic = isPublic,
                    categoryIds = categoryIds,
                    metadata = metadata,
                    userIds = userIds,
                    avatarFileId = avatarFileId,
                    needApprovalOnPostCreation = needApprovalOnPostCreation,
                    onlyAdminCanPost = onlyAdminCanPost
            )
        }
    }

}