package com.amity.socialcloud.sdk.social.community

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.amity.socialcloud.sdk.core.permission.AmityPermissions
import com.amity.socialcloud.sdk.core.permission.AmityRoles
import com.amity.socialcloud.sdk.core.user.AmityUser
import com.google.gson.JsonObject
import kotlinx.android.parcel.Parcelize
import kotlinx.android.parcel.TypeParceler
import org.amity.types.ObjectId
import org.joda.time.DateTime

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
data class AmityCommunityMember internal constructor(
    private val communityId: String = ObjectId.get().toHexString(),
    private val userId: String,
    private val channelId: String,
    private val isBanned: Boolean,
    private var roles: AmityRoles,
    private var permissions: AmityPermissions,
    private val createdAt: DateTime,
    private val updatedAt: DateTime,
    internal var user: AmityUser?
) : Parcelable {

    fun getCommunityId(): String {
        return communityId
    }

    fun getUserId(): String {
        return userId
    }

    fun getChannelId(): String {
        return channelId
    }

    fun isBanned(): Boolean {
        return isBanned
    }

    fun getUser(): AmityUser? {
        return user
    }

    fun getRoles(): AmityRoles {
        return roles
    }

    fun getCreatedAt() : DateTime {
        return createdAt
    }

    fun getUpdatedAt(): DateTime {
        return updatedAt
    }

}