package com.amity.socialcloud.sdk.social.community


import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.community.RemoveUsersCommunityParticipationUseCase
import com.ekoapp.ekosdk.internal.usecase.community.AddUsersCommunityParticipationUseCase
import io.reactivex.Completable

class AmityCommunityParticipation(private val communityId: String) {

    fun getMembers(): AmityCommunityMembershipQuery.Builder {
        return AmityCommunityMembershipQuery.Builder(communityId)
    }

    fun addMembers(userIds: List<String>): Completable {
        return AddUsersCommunityParticipationUseCase().execute(communityId, userIds).toV2()
    }

    fun removeMembers(userIds: List<String>): Completable {
        return RemoveUsersCommunityParticipationUseCase().execute(communityId, userIds).toV2()
    }

    fun searchMembers(keyword: String): AmityCommunityMemberSearch.Builder {
        return AmityCommunityMemberSearch.Builder(communityId, keyword)
    }

}