package com.amity.socialcloud.sdk.social.community

import com.amity.socialcloud.sdk.core.user.AmityMembershipType
import com.google.common.collect.Lists

enum class AmityCommunityMembershipFilter constructor(val value: String, val memberships: List<String>) {

    ALL("all", Lists.newArrayList<String>(AmityMembershipType.MEMBER.apiKey, AmityMembershipType.BANNED.apiKey)),
    MEMBER("member", listOf<String>(AmityMembershipType.MEMBER.apiKey)),
    BANNED("banned", listOf<String>(AmityMembershipType.BANNED.apiKey));

    companion object {
        fun fromApiKey(value: String): AmityCommunityMembershipFilter {
            values().forEach { filter ->
                if (filter.value == value) {
                    return filter
                }
            }
            return MEMBER
        }
    }
}