package com.amity.socialcloud.sdk.social.community

import androidx.paging.PagedList
import androidx.paging.PagingData
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.community.CommunityMembershipPagingDataUseCase
import com.ekoapp.ekosdk.internal.usecase.community.QueryCommunityMembershipListUseCase
import io.reactivex.Flowable

class AmityCommunityMembershipQuery internal constructor(
    private var communityId: String,
    private var roles: List<String>?,
    private var filter: AmityCommunityMembershipFilter,
    private var sortBy: AmityCommunityMembershipSortOption
) {

    @Deprecated("Use getPagingData() instead")
    fun query(): Flowable<PagedList<AmityCommunityMember>> {
        return QueryCommunityMembershipListUseCase().execute(
            communityId,
            roles,
            filter,
            sortBy
        ).toV2()
    }

    fun getPagingData(): Flowable<PagingData<AmityCommunityMember>> {
        return CommunityMembershipPagingDataUseCase().execute(
            communityId,
            roles,
            filter,
            sortBy
        )
    }

    class Builder(private var communityId: String) {
        private var roles: List<String>? = null
        private var filter: AmityCommunityMembershipFilter = AmityCommunityMembershipFilter.MEMBER
        private var sortBy = AmityCommunityMembershipSortOption.FIRST_CREATED

        fun filter(filter: AmityCommunityMembershipFilter): Builder {
            return apply { if (filter != AmityCommunityMembershipFilter.ALL) this.filter = filter }
        }

        fun roles(roles: List<String>): Builder {
            return apply { this.roles = roles }
        }

        fun sortBy(sortBy: AmityCommunityMembershipSortOption): Builder {
            return apply { this.sortBy = sortBy }
        }

        fun build(): AmityCommunityMembershipQuery {
            return AmityCommunityMembershipQuery(
                communityId,
                roles,
                filter,
                sortBy
            )
        }
    }
}