package com.amity.socialcloud.sdk.social.community

import androidx.paging.PagingData
import com.amity.socialcloud.sdk.core.permission.AmityRoles
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.community.membership.query.AmityCommunityMembership
import com.ekoapp.ekosdk.internal.usecase.community.SearchCommunityMembershipPagingSourceUseCase
import io.reactivex.Flowable

class AmityCommunityMemberSearch internal constructor(
    private var communityId: String,
    private var roles: AmityRoles,
    private var communityMembership: List<AmityCommunityMembership>?,
    private var keyword: String,
) {

    fun getPagingData(): Flowable<PagingData<AmityCommunityMember>> {
        return SearchCommunityMembershipPagingSourceUseCase().execute(
            communityId,
            roles,
            communityMembership,
            keyword
        ).toV2()
    }

    class Builder private constructor() {
        private lateinit var communityId: String
        private lateinit var keyword: String
        private var roles = AmityRoles()
        private var communityMembership: List<AmityCommunityMembership>? = null

        internal constructor(communityId: String, keyword: String) : this() {
            this.communityId = communityId
            this.keyword = keyword
        }

        fun membershipFilter(communityMembership: List<AmityCommunityMembership>): Builder {
            return apply { this.communityMembership = communityMembership }
        }

        fun roles(roles: List<String>): Builder {
            return apply {
                this.roles = AmityRoles(roles)
            }
        }

        fun build(): AmityCommunityMemberSearch {
            return AmityCommunityMemberSearch(
                communityId,
                roles,
                communityMembership,
                keyword
            )
        }
    }
}