package com.amity.socialcloud.sdk.social.community

import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.community.BanUsersCommunityUseCase
import com.ekoapp.ekosdk.internal.usecase.community.UnBanUsersCommunityUseCase
import com.ekoapp.ekosdk.internal.usecase.community.AddRolesUseCase
import com.ekoapp.ekosdk.internal.usecase.community.RemoveRolesUseCase
import io.reactivex.Completable


class AmityCommunityModeration(private val communityId: String) {

    @Deprecated(
        "This method is deprecated",
        ReplaceWith(expression = "AmitySocialClient.newCommunityRepository().moderation().addRoles()"),
        DeprecationLevel.WARNING
    )
    fun addRole(role: String, userIds: List<String>): Completable {
        return addRoles(listOf(role), userIds)
    }

    @Deprecated(
        "This method is deprecated",
        ReplaceWith(expression = "AmitySocialClient.newCommunityRepository().moderation().removeRoles()"),
        DeprecationLevel.WARNING
    )
    fun removeRole(role: String, userIds: List<String>): Completable {
        return removeRoles(listOf(role), userIds)
    }

    fun addRoles(roles: List<String>, userIds: List<String>): Completable {
        return AddRolesUseCase().execute(communityId, roles, userIds).toV2()
    }

    fun removeRoles(roles: List<String>, userIds: List<String>): Completable {
        return RemoveRolesUseCase().execute(communityId, roles, userIds).toV2()
    }

    fun banUsers(userIds: List<String>): Completable {
        return BanUsersCommunityUseCase().execute(communityId, userIds).toV2()
    }

    fun unbanUsers(userIds: List<String>): Completable {
        return UnBanUsersCommunityUseCase().execute(communityId, userIds).toV2()
    }
}