package com.amity.socialcloud.sdk.social.community

import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.channel.GetCommunityNotificationUseCase
import com.ekoapp.ekosdk.internal.usecase.channel.UpdateCommunityNotificationUseCase
import io.reactivex.Completable
import io.reactivex.Single

class AmityCommunityNotification internal constructor(private val communityId: String) {

    fun enable(eventModifiers: List<AmityCommunityNotificationEvent.MODIFIER>? = null): Completable {
        return UpdateCommunityNotificationUseCase().execute(communityId, true, eventModifiers).toV2()
    }

    fun disable(): Completable {
        return UpdateCommunityNotificationUseCase().execute(communityId, false).toV2()
    }

    fun getSettings(): Single<AmityCommunityNotificationSettings> {
        return GetCommunityNotificationUseCase().execute(communityId).toV2()
    }

}