package com.amity.socialcloud.sdk.social.community

internal enum class AmityCommunityNotificationEventName(val value: String) {
    POST_CREATED("post.created"),
    POST_REACTED("post.reacted"),
    COMMENT_CREATED("comment.created"),
    COMMENT_REPLIED("comment.replied"),
    COMMENT_REACTED("comment.reacted"),
    UNKNOWN_EVENT("unknown");

    companion object {
        fun enumOf(value: String?): AmityCommunityNotificationEventName {
            return values().find { it.value == value } ?: UNKNOWN_EVENT
        }
    }

}