package com.amity.socialcloud.sdk.social.community

import androidx.paging.PagedList
import androidx.paging.PagingData
import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.community.QueryCommunityListPagingDataUseCase
import com.ekoapp.ekosdk.internal.usecase.community.QueryCommunityListUseCase
import io.reactivex.Flowable

class AmityCommunityQuery internal constructor(val keyword: String,
                                               val categoryId: String,
                                               val filter: AmityCommunityFilter,
                                               val sortBy: AmityCommunitySortOption,
                                               val isDeleted: Boolean?) {
    
    @Deprecated("Use getPagingData() instead")
    fun query(): Flowable<PagedList<AmityCommunity>> {
        return QueryCommunityListUseCase().execute(
                keyword = keyword,
                categoryId = categoryId,
                filter = filter,
                sortBy = sortBy,
                isDeleted = isDeleted
        ).toV2()
    }
    
    fun getPagingData(): Flowable<PagingData<AmityCommunity>> {
        return QueryCommunityListPagingDataUseCase().execute(
                keyword = keyword,
                categoryId = categoryId,
                filter = filter,
                sortBy = sortBy,
                isDeleted = isDeleted
        ).toV2()
    }
}