package com.amity.socialcloud.sdk.social.community

import com.ekoapp.core.utils.requiredNonNull

class AmityCommunityQueryWithKeywordBuilder {

    class Builder {
        private var keyword: String? = null
        private var categoryId: String? = null
        private var filter: AmityCommunityFilter = AmityCommunityFilter.ALL
        private var sortBy: AmityCommunitySortOption = AmityCommunitySortOption.DISPLAY_NAME
        private var isDeleted: Boolean? = null

        fun withKeyword(keyword: String): Builder {
            return apply { this.keyword = keyword }
        }

        fun categoryId(categoryId: String): Builder {
            return apply { this.categoryId = categoryId }
        }

        fun filter(filter: AmityCommunityFilter): Builder {
            return apply { this.filter = filter }
        }

        fun sortBy(sortBy: AmityCommunitySortOption): Builder {
            return apply { this.sortBy = sortBy }
        }

        fun includeDeleted(includeDeleted: Boolean): Builder {
            if (!includeDeleted) {
                this.isDeleted = false
            }
            return this
        }

        fun build(): AmityCommunityQuery {
            return AmityCommunityQuery(
                    keyword = requiredNonNull(keyword),
                    categoryId = requiredNonNull(categoryId),
                    filter = filter,
                    sortBy = sortBy,
                    isDeleted = isDeleted
            )
        }
    }
}