package com.amity.socialcloud.sdk.social.community

import com.amity.socialcloud.sdk.log.AmityLog
import com.google.common.base.Objects

enum class AmityCommunitySortOption(val apiKey: String,
                                    val sortingColumn: String,
                                    val sortingOrder: String) {
    DISPLAY_NAME("displayName", "community.displayName", AmityQuerySortingOrder.ASC.sqlOrder), FIRST_CREATED("firstCreated", "community.createdAt", AmityQuerySortingOrder.ASC.sqlOrder), LAST_CREATED("lastCreated", "community.createdAt", AmityQuerySortingOrder.DESC.sqlOrder);

    companion object {
        fun fromApiKey(apiKey: String?): AmityCommunitySortOption {
            for (filter in values()) {
                if (Objects.equal(apiKey, filter.apiKey)) {
                    return filter
                }
            }
            AmityLog.e(Exception(), "unknown api key : %s of user sort option", apiKey)
            return LAST_CREATED
        }
    }
}