package com.amity.socialcloud.sdk.social.community

import com.ekoapp.core.utils.toV2
import com.ekoapp.ekosdk.internal.usecase.community.UpdateCommunityUseCase
import com.google.gson.JsonObject
import io.reactivex.Single

class AmityCommunityUpdate {
    private var communityId: String
    private var displayName: String? = null
    private var description: String? = null
    private var isPublic: Boolean? = null
    private var categoryIds: List<String>? = null
    private var metadata: JsonObject? = null
    private var avatarFileId: String? = null
    private var needApprovalOnPostCreation: Boolean? = null
    private var onlyAdminCanPost: Boolean? = null

    internal constructor(communityId: String, displayName: String?,
                         description: String?, isPublic: Boolean?,
                         categoryIds: List<String>?, metadata: JsonObject?,
                         avatarFileId: String?, needApprovalOnPostCreation:Boolean?,
                         onlyAdminCanPost: Boolean?) {

        this.communityId = communityId
        this.displayName = displayName
        this.description = description
        this.isPublic = isPublic
        this.categoryIds = categoryIds
        this.metadata = metadata
        this.avatarFileId = avatarFileId
        this.needApprovalOnPostCreation = needApprovalOnPostCreation
        this.onlyAdminCanPost = onlyAdminCanPost
    }

    fun update(): Single<AmityCommunity> {
        return updateCommunity()

    }

    private fun updateCommunity(): Single<AmityCommunity> {
        return UpdateCommunityUseCase().execute(
                communityId,
                displayName,
                description,
                categoryIds,
                isPublic,
                metadata,
                avatarFileId,
                needApprovalOnPostCreation,
                onlyAdminCanPost).toV2()
    }

}