package com.amity.socialcloud.sdk.social.community

import com.amity.socialcloud.sdk.core.file.AmityImage
import com.ekoapp.ekosdk.community.update.AmityCommunityPostSettings
import com.google.gson.JsonObject

class AmityCommunityWithCommunityIdByAdminUpdate {
    class Builder(private val communityId: String) {
        private var displayName: String? = null
        private var description: String? = null
        private var isPublic: Boolean? = null
        private var categoryIds: List<String>? = null
        private var metadata: JsonObject? = null
        private var avatarFileId: String? = null
        private var needApprovalOnPostCreation:Boolean? = null
        private var postSettings: AmityCommunityPostSettings? = null

        fun displayName(displayName: String): Builder {
            return apply { this.displayName = displayName }
        }

        fun description(description: String): Builder {
            return apply { this.description = description }
        }

        fun isPublic(isPublic: Boolean): Builder {
            return apply { this.isPublic = isPublic }
        }

        fun categoryIds(categoryIds: List<String>): Builder {
            return apply { this.categoryIds = categoryIds }
        }

        fun metadata(metadata: JsonObject): Builder {
            return apply { this.metadata = metadata }
        }

        fun avatar(avatar: AmityImage): Builder {
            return apply { this.avatarFileId = avatar.getFileId() }
        }
    
        @Deprecated("Use postSettings() instead")
        fun isPostReviewEnabled(isPostReviewEnabled:Boolean): Builder {
            return apply { needApprovalOnPostCreation = isPostReviewEnabled }
        }
        
        fun postSettings(postSettings: AmityCommunityPostSettings): Builder {
            return apply {
                this.postSettings = postSettings
                this.needApprovalOnPostCreation = postSettings.isPostReviewEnabled
            }
        }

        fun build(): AmityCommunityUpdate {
            return AmityCommunityUpdate(
                    communityId = communityId,
                    displayName = displayName,
                    description = description,
                    isPublic = isPublic,
                    categoryIds = categoryIds,
                    metadata = metadata,
                    avatarFileId = avatarFileId,
                    needApprovalOnPostCreation = postSettings?.isPostReviewEnabled,
                    onlyAdminCanPost = postSettings?.onlyAdminCanPost
            )
        }
    }
}