package com.amity.socialcloud.sdk.social.feed

enum class AmityFeedType(val apiKey: String) {
    PUBLISHED("published"),
    REVIEWING("reviewing"),
    DECLINED("declined"),
    NONE("none");

    companion object {
        fun enumOf(value: String?): AmityFeedType {
            return values().find { it.apiKey == value } ?: NONE
        }
    }
}