package com.amity.socialcloud.sdk.social.feed

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.google.gson.JsonObject
import kotlinx.android.parcel.Parcelize
import kotlinx.android.parcel.TypeParceler
import org.joda.time.DateTime

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
data class AmityPoll internal constructor(
    private val pollId: String,
    private val userId: String,
    private val question: String,
    private val answers: List<AmityPollAnswer>,
    private val answerType: AnswerType,
    private val status: Status,
    private val closedAt: DateTime,
    private val isDeleted: Boolean,
    private val isVoted: Boolean,
    private val createdAt: DateTime,
    private val updatedAt: DateTime
) : Parcelable {

    fun getPollId(): String {
        return pollId
    }

    fun getUserId(): String {
        return userId
    }

    fun getQuestion(): String {
        return question
    }

    fun getAnswers(): List<AmityPollAnswer> {
        return answers
    }

    fun getAnswerType(): AnswerType {
        return answerType
    }

    fun getStatus(): Status {
        return status
    }

    fun getClosedAt(): DateTime {
        return closedAt
    }

    fun isDeleted(): Boolean {
        return isDeleted
    }

    fun isVoted(): Boolean {
        return isVoted
    }

    fun getCreatedAt(): DateTime {
        return createdAt
    }

    fun getUpdatedAt(): DateTime {
        return updatedAt
    }

    sealed class AnswerType(val apiKey: String) : Parcelable {

        @Parcelize
        object SINGLE : AnswerType("single")

        @Parcelize
        object MULTIPLE : AnswerType("multiple")

        @Parcelize
        internal object UNKNOWN : AnswerType("unknown")

        companion object {
            fun fromApiKey(apiKey: String): AnswerType {
                return when (apiKey) {
                    SINGLE.apiKey -> SINGLE
                    MULTIPLE.apiKey -> MULTIPLE
                    else -> UNKNOWN
                }
            }
        }
    }

    sealed class Status(val apiKey: String) : Parcelable {

        @Parcelize
        object OPEN : Status("open")

        @Parcelize
        object CLOSED : Status("closed")

        @Parcelize
        internal object UNKNOWN : Status("unknown")

        companion object {
            fun fromApiKey(apiKey: String): Status {
                return when (apiKey) {
                    OPEN.apiKey -> OPEN
                    CLOSED.apiKey -> CLOSED
                    else -> UNKNOWN
                }
            }
        }
    }
}