package com.amity.socialcloud.sdk.social.feed

import com.amity.socialcloud.sdk.core.file.AmityImage
import com.amity.socialcloud.sdk.core.mention.AmityMentionType
import com.amity.socialcloud.sdk.core.mention.AmityMentioneeTarget
import com.google.gson.JsonObject

class AmityImagePostCreatorV4 private constructor(
    targetType: String,
    targetId: String,
    private val text: String,
    private val images: List<AmityImage>,
    metadata: JsonObject?,
    mentionees: List<AmityMentioneeTarget>?
) : AmityPostCreatorV4(targetType, targetId, metadata, mentionees) {

    class Builder {
        private var targetType = ""
        private var targetId = ""
        private var text = ""
        private var images: List<AmityImage> = mutableListOf()
        private var metadata: JsonObject? = null
        private var mentionees: List<AmityMentioneeTarget>? = null

        internal fun targetType(targetType: String): Builder {
            this.targetType = targetType
            return this
        }

        internal fun targetId(targetId: String): Builder {
            this.targetId = targetId
            return this
        }

        fun text(text: String): Builder {
            this.text = text
            return this
        }

        internal fun images(vararg images: AmityImage): Builder {
            this.images = images.asList()
            return this
        }

        fun metadata(metadata: JsonObject): Builder {
            this.metadata = metadata
            return this
        }

        fun mentionUsers(userIds: List<String>): Builder {
            this.mentionees =
                listOf(AmityMentioneeTarget(AmityMentionType.USER.apiKey, userIds))
            return this
        }

        fun build(): AmityImagePostCreatorV4 {
            return AmityImagePostCreatorV4(targetType, targetId, text, images, metadata, mentionees)
        }
    }

    override fun getPostDataType(): AmityPost.DataType {
        return AmityPost.DataType.IMAGE
    }

    override fun getFiles(): List<AmityImage> {
        return images
    }

    override fun getText(): String {
        return text
    }
}