package com.amity.socialcloud.sdk.social.feed

import com.amity.socialcloud.sdk.core.mention.AmityMentionType
import com.amity.socialcloud.sdk.core.mention.AmityMentioneeTarget
import com.google.gson.JsonObject

class AmityLiveStreamPostCreator private constructor(
    targetType: String,
    targetId: String,
    private val text: String,
    private val streamId: String,
    metadata: JsonObject?,
    mentionees: List<AmityMentioneeTarget>?
) : AmityPostCreatorV4(targetType, targetId, metadata, mentionees) {

    class Builder {
        private var targetType = ""
        private var targetId = ""
        private var text = ""
        private var streamId = ""
        private var metadata: JsonObject? = null
        private var mentionees: List<AmityMentioneeTarget>? = null

        internal fun targetType(targetType: String): Builder {
            this.targetType = targetType
            return this
        }

        internal fun targetId(targetId: String): Builder {
            this.targetId = targetId
            return this
        }

        fun text(text: String): Builder {
            this.text = text
            return this
        }

        fun streamId(streamId: String): Builder {
            this.streamId = streamId
            return this
        }
    
        fun metadata(metadata: JsonObject): Builder {
            this.metadata = metadata
            return this
        }
    
        fun mentionUsers(userIds: List<String>): Builder {
            this.mentionees = listOf(AmityMentioneeTarget(AmityMentionType.USER.apiKey, userIds))
            return this
        }

        fun build(): AmityLiveStreamPostCreator {
            return AmityLiveStreamPostCreator(targetType, targetId, text, streamId, metadata, mentionees)
        }
    }

    override fun isCustomDataType(): Boolean {
        return true
    }

    override fun getPostDataType(): AmityPost.DataType {
        return AmityPost.DataType.LIVE_STREAM
    }

    override fun composeData(): JsonObject {
        val data = JsonObject()
        data.addProperty(TEXT_DATA_KEY, getText())
        data.addProperty(STREAM_DATA_KEY, streamId)
        return data
    }

    override fun getText(): String {
        return text
    }
}

private const val STREAM_DATA_KEY = "streamId"