package com.amity.socialcloud.sdk.social.feed

import com.amity.socialcloud.sdk.core.AmityFile
import com.amity.socialcloud.sdk.core.AmityVideo
import com.amity.socialcloud.sdk.core.file.AmityImage


abstract class AmityPostCreateDataTypeSelector(private val targetType: String, private val targetId: String) {

    fun text(text: String): AmityTextPostCreator.Builder {
        return AmityTextPostCreator.Builder()
                .targetType(targetType)
                .targetId(targetId)
                .text(text)
    }

    fun image(vararg images: AmityImage): AmityImagePostCreator.Builder {
        return AmityImagePostCreator.Builder()
                .targetType(targetType)
                .targetId(targetId)
                .images(*images)
    }

    fun file(vararg files: AmityFile): AmityFilePostCreator.Builder {
        return AmityFilePostCreator.Builder()
                .targetType(targetType)
                .targetId(targetId)
                .files(*files)
    }

    fun video(vararg videos: AmityVideo): AmityVideoPostCreator.Builder {
        return AmityVideoPostCreator.Builder()
                .targetType(targetType)
                .targetId(targetId)
                .videos(*videos)
    }

    fun poll(pollId: String): AmityPollPostCreator.Builder {
        return AmityPollPostCreator.Builder()
            .targetType(targetType)
            .targetId(targetId)
            .pollId(pollId)
    }

    fun liveStream(streamId: String): AmityLiveStreamPostCreator.Builder {
        return AmityLiveStreamPostCreator.Builder()
            .targetType(targetType)
            .targetId(targetId)
            .streamId(streamId)
    }
}
